<?php
/**
 * Plugin Name:       Consent Agency Hub
 * Plugin URI:        https://wpconsentmanage.com/wp-consent-manager/
 * Description:       Central dashboard for managing Consent Manager GDPR & CCPA on multiple client sites.
 * Version:           1.1.1
 * Author:            Pitter de Barros Lopes
 * Author URI:        https://wpconsentmanage.com/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       wpcm-agency-hub
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; 
}

define( 'WPCM_HUB_VERSION', '1.1.1' );
define( 'WPCM_HUB_PATH', plugin_dir_path( __FILE__ ) );
define( 'WPCM_HUB_URL', plugin_dir_url( __FILE__ ) );

if ( file_exists( WPCM_HUB_PATH . 'vendor/autoload.php' ) ) {
	require_once WPCM_HUB_PATH . 'vendor/autoload.php';
}

require_once WPCM_HUB_PATH . 'includes/autoloader.php';

// 4. INTEGRAÇÃO FREEMIUS
if ( ! function_exists( 'wpcm_hub_fs' ) ) {
    function wpcm_hub_fs() {
        global $wpcm_hub_fs;

        if ( ! isset( $wpcm_hub_fs ) ) {
            require_once dirname(__FILE__) . '/vendor/freemius/start.php';

            $wpcm_hub_fs = fs_dynamic_init( array(
                'id'                  => '21950',
                'slug'                => 'wpcm-agency-hub',
                'type'                => 'plugin',
                'public_key'          => 'pk_f796216b9c2f3d11c89a13431d68a',
                'is_premium'          => true,
                'is_premium_only'     => true, // Força a tela de ativação
                'has_addons'          => false,
                'has_paid_plans'      => true,
                'is_org_compliant'    => false,
                'trial'               => array(
                    'days'               => 7,
                    'is_require_payment' => true,
                ),
                // Menu removido para evitar conflito de permissão na ativação
            ) );
        }

        return $wpcm_hub_fs;
    }

    wpcm_hub_fs();
    do_action( 'wpcm_hub_fs_loaded' );
}

register_activation_hook( __FILE__, array( 'WPCM_Hub_Core', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'WPCM_Hub_Core', 'deactivate' ) );

if ( function_exists('wpcm_hub_fs') ) {
    wpcm_hub_fs()->add_action('after_uninstall', 'wpcm_hub_uninstall_cleanup');
}

function wpcm_hub_uninstall_cleanup() {
    if ( file_exists( WPCM_HUB_PATH . 'uninstall.php' ) ) {
        include_once WPCM_HUB_PATH . 'uninstall.php';
    }
}

/**
 * Carrega o Plugin - AGORA COM O PORTEIRO
 */
function wpcm_hub_load_plugin() {
    
    // 1. Verifica se o Freemius está carregado
    if ( ! function_exists( 'wpcm_hub_fs' ) ) {
        return;
    }

    // 2. O PORTEIRO: Verifica se o usuário tem licença válida
    // Se não tiver (e não estiver no trial), o código para aqui.
    // Nenhum menu do Hub será criado, apenas a tela de ativação do Freemius aparecerá.
    if ( ! wpcm_hub_fs()->can_use_premium_code() ) {
        return;
    }

    // 3. Se passou pelo porteiro, carrega as dependências e o núcleo
	if ( file_exists( WPCM_HUB_PATH . 'vendor/action-scheduler/action-scheduler.php' ) ) {
        require_once WPCM_HUB_PATH . 'vendor/action-scheduler/action-scheduler.php';
    }
    
    new WPCM_Hub_Core();
}
add_action( 'plugins_loaded', 'wpcm_hub_load_plugin' );