<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Lida com a EXECUÇÃO de trabalhos em segundo plano.
 * Registra os ganchos do Action Scheduler.
 * ATUALIZADO (Sprint 5): Adiciona verificação SSL dinâmica
 */
class WPCM_Hub_Job_Runner {

	public function __construct() {
		// Registra o gancho que o Agendador (Scheduler) chama
		add_action( 'wpcm_hub_sync_site_job', array( $this, 'run_site_sync_job' ) );
	}

	/**
	 * O trabalho real que é executado em segundo plano.
	 * Sincroniza um único site.
	 *
	 * ATUALIZADO: Agora verifica o meta '_disable_sslverify'
	 *
	 * @param int $site_id
	 */
	public function run_site_sync_job( $site_id ) {
		$site_url = get_post_meta( $site_id, '_site_url', true );
		$api_key  = get_post_meta( $site_id, '_api_key', true );
		$status   = get_post_meta( $site_id, '_status', true );

		// Verificação de segurança tripla
		if ( empty( $site_url ) || empty( $api_key ) || $status !== 'connected' ) {
			return;
		}

		// --- INÍCIO DA ADIÇÃO (Segurança SSL) ---
		// Busca a configuração salva no CPT do Site
		$disable_ssl = get_post_meta( $site_id, '_disable_sslverify', true );
		
		// Converte o '1' (salvo) para 'false' (para wp_remote_post)
		// e o '0' (padrão) para 'true' (seguro).
		$ssl_verify_status = ( $disable_ssl === '1' ) ? false : true;
		// --- FIM DA ADIÇÃO ---


		// O endpoint que criamos no plugin do Cliente
		$api_endpoint = trailingslashit( $site_url ) . 'wp-json/wpcm-client/v1/clear_cache';

		wp_remote_post(
			$api_endpoint,
			array(
				'method'     => 'POST',
				'timeout'    => 15,
				'body'       => array( 'api_key' => $api_key ),
				'user-agent' => 'WPCM-Hub/' . WPCM_HUB_VERSION,
				'sslverify'  => $ssl_verify_status, // ATUALIZADO: Usa o status dinâmico
			)
		);
	}
}