<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Creates the Hub Help & Documentation Page (Sprint 9)
 * (CORRECTED: All strings in English and internationalized)
 */
class WPCM_Hub_Help_Page {

    public function __construct() {
        // Adds the submenu to the main Hub menu
        add_action( 'admin_menu', array( $this, 'add_help_page' ) );
    }

    /**
     * Adds the "Help & Documentation" submenu page
     */
    public function add_help_page() {
        add_submenu_page(
            'edit.php?post_type=wpcm_hub_site', // Parent slug
            __( 'Help & Documentation', 'wpcm-agency-hub' ), // Page Title
            __( 'Help & Documentation', 'wpcm-agency-hub' ), // Menu Title
            'manage_options',
            'wpcm_hub_help',
            array( $this, 'render_help_page' )
        );
    }

    /**
     * Renders the content of the Help page
     */
    public function render_help_page() {
        ?>
        <div class="wrap wpcm-help-wrap">
            <h1 class="wp-heading-inline"><?php esc_html_e( 'Consent Agency Hub', 'wpcm-agency-hub' ); ?></h1>
            <span class="page-title-count-3" style="margin-left: 5px;"><?php echo esc_html( WPCM_HUB_VERSION ); ?></span>
            
            <div class="wpcm-help-header">
                <span class="dashicons dashicons-sos"></span>
                <p><?php esc_html_e( 'Welcome to your documentation center. Find everything you need to manage client consent efficiently.', 'wpcm-agency-hub' ); ?></p>
            </div>

            <div class="wpcm-help-grid">

                <div class="wpcm-help-card">
                    <div class="wpcm-help-card-header">
                        <span class="dashicons dashicons-networking"></span>
                        <h3><?php esc_html_e( 'The Core Architecture', 'wpcm-agency-hub' ); ?></h3>
                    </div>
                    <div class="wpcm-help-card-content">
                        <p><?php esc_html_e( 'The plugin is based on a "Library" and "Kit" concept:', 'wpcm-agency-hub' ); ?></p>
                        <ol>
                            <li><strong><?php esc_html_e( 'Global Settings & Services (The Library):', 'wpcm-agency-hub' ); ?></strong><br>
                                <?php esc_html_e( 'Think of "Global Services" as your master arsenal. This is where you create and store ALL services your agency knows how to configure (Google Analytics, Meta, TikTok, etc.).', 'wpcm-agency-hub' ); ?></li>
                            
                            <li><strong><?php esc_html_e( 'Configuration Profiles (The Kit):', 'wpcm-agency-hub' ); ?></strong><br>
                                <?php esc_html_e( 'Think of "Profiles" as a kit you build for a specific client. You take the services you need from your "Library" and put them in this kit.', 'wpcm-agency-hub' ); ?></li>
                            
                            <li><strong><?php esc_html_e( 'Connected Sites (The Delivery):', 'wpcm-agency-hub' ); ?></strong><br>
                                <?php esc_html_e( 'Here, you connect the client\'s site and, using the "Assign Config. Profile" dropdown, you deliver the correct "Kit" (Profile) to that client.', 'wpcm-agency-hub' ); ?></li>
                        </ol>
                    </div>
                </div>

                <div class="wpcm-help-card">
                    <div class="wpcm-help-card-header">
                        <span class="dashicons dashicons-admin-links"></span>
                        <h3><?php esc_html_e( 'How to Connect a Client', 'wpcm-agency-hub' ); ?></h3>
                    </div>
                    <div class="wpcm-help-card-content">
                        <p><?php esc_html_e( 'Follow this flow for the best experience:', 'wpcm-agency-hub' ); ?></p>
                        <ol>
                            <li><strong><?php esc_html_e( '(Optional) Create the Profile:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'Go to <strong>Config. Profiles</strong> and create a Design and Services Profile for this client (e.g., "Client X Profile").', 'wpcm-agency-hub' ); ?></li>
                            
                            <li><strong><?php esc_html_e( 'Create the Site in the Hub:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'Go to <strong>All Connected Sites > Add New Site</strong>. Give it a name (e.g., "Client X Site") and save.', 'wpcm-agency-hub' ); ?></li>
                            
                            <li><strong><?php esc_html_e( 'Copy the Key:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'When editing the "Client X Site", you will see the <strong>Site API Key</strong>. Copy this key.', 'wpcm-agency-hub' ); ?></li>
                            
                            <li><strong><?php esc_html_e( 'On the Client Site:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'Install the Client plugin. In the client\'s dashboard, go to the plugin\'s settings page, paste the API Key and your Hub URL, and connect.', 'wpcm-agency-hub' ); ?></li>
                            
                            <li><strong><?php esc_html_e( 'Test the Connection:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'Back in your Hub, edit the "Client X Site" and click the <strong>"Run Test"</strong> button. You should get a "Success!" message.', 'wpcm-agency-hub' ); ?></li>
                        </ol>
                    </div>
                </div>

                <div class="wpcm-help-card">
                    <div class="wpcm-help-card-header">
                        <span class="dashicons dashicons-admin-customizer"></span>
                        <h3><?php esc_html_e( 'Profile Workflow', 'wpcm-agency-hub' ); ?></h3>
                    </div>
                    <div class="wpcm-help-card-content">
                        <p><?php esc_html_e( 'Profiles are how you give each client a unique design and set of services.', 'wpcm-agency-hub' ); ?></p>
                        <ol>
                            <li><strong><?php esc_html_e( 'Specific Settings:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'Use the "Design" and "Content" tabs inside a Profile to override the "Global Settings".', 'wpcm-agency-hub' ); ?></li>
                            
                            <li><strong><?php esc_html_e( 'Specific Services:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'Use the "Services" tab to select <strong>which</strong> "Global Services" (from your library) this specific Profile will use.', 'wpcm-agency-hub' ); ?></li>
                            
                            <li><strong><?php esc_html_e( 'Assignment:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'If a site has no Profile assigned (set to "— Use Global Settings —"), it will use the default "Global Settings" and <strong>ALL</strong> published "Global Services".', 'wpcm-agency-hub' ); ?></li>
                        </ol>
                    </div>
                </div>

                <div class="wpcm-help-card">
                    <div class="wpcm-help-card-header">
                        <span class="dashicons dashicons-warning"></span>
                        <h3><?php esc_html_e( 'Troubleshooting (FAQ)', 'wpcm-agency-hub' ); ?></h3>
                    </div>
                    <div class="wpcm-help-card-content">
                        <p><strong><?php esc_html_e( 'Q: "Test Connection" failed. What do I do?', 'wpcm-agency-hub' ); ?></strong><br>
                           <strong><?php esc_html_e( 'A: Check 3 things:', 'wpcm-agency-hub' ); ?></strong>
                           <?php echo sprintf(
                               '<ol><li>%s</li><li>%s</li><li>%s</li></ol>',
                               esc_html__( 'Are the API Key on the client and Hub 100% identical?', 'wpcm-agency-hub' ),
                               sprintf( 
                                   /* translators: %s: Protocol example (https://) */
                                   esc_html__( 'Is the Site URL correct (with %s) and is it the right site?', 'wpcm-agency-hub' ), 
                                   'https://' 
                               ),
                               esc_html__( 'Does the client site have a broken SSL? If so, check the "Disable SSL Verification" box (Sprint 5) and try again.', 'wpcm-agency-hub' )
                           ); ?>
                        </p>
                        <hr style="border: 0; border-top: 1px solid #eee; margin: 15px 0;">
                        <p><strong><?php esc_html_e( 'Q: I created a Profile, but a service (e.g., TikTok) doesn\'t appear in the "Services" tab. Why?', 'wpcm-agency-hub' ); ?></strong><br>
                           <strong><?php esc_html_e( 'A:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'This is intentional. The Profile "Services" tab only shows services that are <strong>Published</strong>. The "TikTok" service is likely still a <strong>"Draft"</strong>. Go to <strong>Global Services</strong>, find "TikTok", and click "Publish". It will now appear in the Profile list.', 'wpcm-agency-hub' ); ?>
                        </p>
                    </div>
                </div>

                <div class="wpcm-help-card">
                    <div class="wpcm-help-card-header">
                        <span class="dashicons dashicons-cloud-saved"></span>
                        <h3><?php esc_html_e( 'How Sync Works', 'wpcm-agency-hub' ); ?></h3>
                    </div>
                    <div class="wpcm-help-card-content">
                        <p><?php esc_html_e( 'The plugin is "smart" and schedules syncs in the background to avoid crashing your site.', 'wpcm-agency-hub' ); ?></p>
                        <ul>
                            <li><strong><?php esc_html_e( 'Auto-Sync:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'Saving a "Global Service", "Global Settings", "Profile", or "Site" automatically schedules the necessary sync jobs (Sprints 2 & 5).', 'wpcm-agency-hub' ); ?></li>
                            <li><strong><?php esc_html_e( '"Sync All Sites" Button:', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'This button (in "Global Settings" & "Global Services") manually schedules a sync for <strong>all</strong> connected sites. The response is immediate ("X sites scheduled...").', 'wpcm-agency-hub' ); ?></li>
                            <li><strong><?php esc_html_e( 'What is Synced?', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'The Hub does not "push" data. It "notifies" the client site (by clearing its cache). The client site then "pulls" the new settings from the Hub\'s API.', 'wpcm-agency-hub' ); ?></li>
                        </ul>
                    </div>
                </div>

                <div class="wpcm-help-card">
                    <div class="wpcm-help-card-header">
                        <span class="dashicons dashicons-chart-pie"></span>
                        <h3><?php esc_html_e( 'Log Dashboard', 'wpcm-agency-hub' ); ?></h3>
                    </div>
                    <div class="wpcm-help-card-content">
                        <p><?php esc_html_e( 'This page is your center for consent proof.', 'wpcm-agency-hub' ); ?></p>
                        <ul>
                            <li><strong><?php esc_html_e( 'Charts (Sprint 6):', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'The charts at the top give you a quick view of your "opt-in rate" and trends, based on your site filter.', 'wpcm-agency-hub' ); ?></li>
                            <li><strong><?php esc_html_e( 'Log Table (Sprint 7):', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'The table shows individual consent. It "translates" IDs (e.g., service_hub_210) into readable names (e.g., "Google Analytics") for clarity.', 'wpcm-agency-hub' ); ?></li>
                            <li><strong><?php esc_html_e( 'Export (Sprint 4):', 'wpcm-agency-hub' ); ?></strong> <?php esc_html_e( 'The "Export CSV" button is performance-optimized and can export millions of rows without crashing the server.', 'wpcm-agency-hub' ); ?></li>
                        </ul>
                    </div>
                </div>

            </div> </div>
        <?php
    }
}