<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Autoloader para as classes do Hub.
 * (Versão 3 - Definitiva)
 *
 * Esta versão é "inteligente" e procura por duas convenções de nomenclatura
 * para lidar com os nomes de arquivo inconsistentes no projeto.
 *
 * @param string $class_name O nome da classe (ex: WPCM_Hub_Core).
 */
function wpcm_hub_autoloader( $class_name ) {
	
	// Carrega apenas classes do nosso plugin
	if ( strpos( $class_name, 'WPCM_Hub_' ) !== 0 ) {
		return;
	}

	// Define os diretórios onde as classes podem estar
	$paths = array(
		WPCM_HUB_PATH . 'includes/api/',
		WPCM_HUB_PATH . 'includes/core/',
		WPCM_HUB_PATH . 'includes/cpt/',
		WPCM_HUB_PATH . 'includes/database/',
		WPCM_HUB_PATH . 'includes/jobs/',
		WPCM_HUB_PATH . 'includes/settings/',
	);

	// --- TENTATIVA 1: Convenção de Nome Completa (ex: class-wpcm-hub-core.php) ---
	$filename_full = 'class-' . str_replace( '_', '-', strtolower( $class_name ) ) . '.php';

	foreach ( $paths as $path ) {
		$file_path = $path . $filename_full;
		if ( file_exists( $file_path ) ) {
			require_once $file_path;
			return; // Encontrou e carregou!
		}
	}

	// --- TENTATIVA 2: Convenção de Nome Curta (ex: class-hub-api.php) ---
	// Remove o prefixo "WPCM_" da classe
	$short_class_name      = str_replace( 'WPCM_', '', $class_name );
	$filename_short = 'class-' . str_replace( '_', '-', strtolower( $short_class_name ) ) . '.php';

	foreach ( $paths as $path ) {
		$file_path = $path . $filename_short;
		if ( file_exists( $file_path ) ) {
			require_once $file_path;
			return; // Encontrou e carregou!
		}
	}

	// Se chegou até aqui, nenhuma das convenções funcionou. O PHP vai disparar o erro.
}

// Registra o autoloader
spl_autoload_register( 'wpcm_hub_autoloader' );