<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package   Consent_Manager_GDPR_CCPA
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

global $wpdb;

// 1. Remover a tabela de log
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}consent_log" );

// 2. Remover opções (options)
delete_option( 'wpcm_settings_options' );
delete_option( 'wpcm_version' );
delete_option( 'wpcm_setup_complete' );

// 3. Remover transientes (cache)
delete_transient( 'wpcm_activation_redirect' );
delete_transient( 'wpcm_log_cache_v' );
delete_transient( 'wpcm_hub_data' );
delete_transient( 'wpcm_sync_logs_lock' );

// 4. Limpar os cron jobs (tarefas agendadas)
wp_clear_scheduled_hook( 'wpcm_daily_log_cleanup' );
wp_clear_scheduled_hook( 'wpcm_sync_logs_event' );

// 5. Limpar quaisquer caches restantes (opcional, mas bom)
wp_cache_flush();