/**
 * Admin Scripts.
 *
 * @package Consent_Manager_GDPR_CCPA
 */
jQuery(document).ready(function($) {

    // Initialize WordPress Color Pickers
    if (typeof $.fn.wpColorPicker === 'function') {
        $('.wpcm-color-picker').wpColorPicker();
    }
    
    /*
     * =================================================================
     * VERIFICAÇÃO DE CONEXÃO DO HUB
     * =================================================================
     */
    $('#wpcm-verify-connection').on('click', function(e) {
        e.preventDefault();

        var $button = $(this);
        var $spinner = $button.next('.spinner');
        var $notice = $('#wpcm-connection-notice');
        
        var hubURL = $('#agency_hub_url').val();
        var apiKey = $('#agency_api_key').val();

        // Verifica se wpcm_admin_vars existe
        if (typeof wpcm_admin_vars === 'undefined') {
            $notice.text('Error: admin.js variables not loaded.').css('color', '#ef4444');
            return;
        }

        $button.prop('disabled', true);
        $spinner.addClass('is-active');
        $notice.empty().removeClass('notice-success notice-error');

        $.post(wpcm_admin_vars.ajax_url, {
            action: 'wpcm_verify_hub_connection',
            nonce: wpcm_admin_vars.nonce,
            hub_url: hubURL,
            api_key: apiKey
        })
        .done(function(response) {
            if (response.success) {
                $notice.text(response.data.message + ' (Site: ' + response.data.site_name + ')').addClass('notice-success').css('color', '#10b981');
                setTimeout(function() {
                    location.reload();
                }, 1000);
            } else {
                $notice.text('Error: ' + response.data.message).addClass('notice-error').css('color', '#ef4444');
            }
        })
        .fail(function() {
            $notice.text(wpcm_admin_vars.text_error).addClass('notice-error').css('color', '#ef4444');
        })
        .always(function() {
            $button.prop('disabled', false);
            $spinner.removeClass('is-active');
        });
    });
    
    
    // *** AQUI ESTÁ A MUDANÇA (SPRINT 10) ***
    /*
     * =================================================================
     * ÍCONE DE CÓPIA DA TABELA DE LOG
     * =================================================================
     */
    $(document).on('click', '.wpcm-copy-icon', function() {
        var hashToCopy = $(this).data('hash');
        
        if ( ! hashToCopy ) return;
        
        navigator.clipboard.writeText(hashToCopy).then(function() {
            // Idealmente, isso seria um 'tooltip' não-invasivo
            alert('Hash copied to clipboard!'); 
        }, function() {
            // Fallback para caso o clipboard falhe
            alert('Failed to copy hash.');
        });
    });
    
});