/**
 * Admin Scanner Scripts.
 *
 * @package Consent_Manager_GDPR_CCPA
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        
        $('#wpcm-start-scan').on('click', function(e) {
            e.preventDefault();
            var $btn = $(this);
            var $results = $('#wpcm-scan-results');
            var $spinner = $btn.next('.spinner');
            
            $btn.addClass('disabled');
            $spinner.addClass('is-active');
            $results.html('<p>Scanning homepage...</p>');

            // 1. Busca o HTML da Home
            fetch(wpcm_scanner_vars.home_url)
                .then(response => response.text())
                .then(html => {
                    var detectedPresets = [];
                    var signatures = wpcm_scanner_vars.signatures;
                    
                    // 2. Parser do HTML (Virtual DOM)
                    var parser = new DOMParser();
                    var doc = parser.parseFromString(html, 'text/html');
                    
                    // 3. Varre Scripts e iFrames
                    var elements = doc.querySelectorAll('script, iframe');
                    
                    elements.forEach(function(el) {
                        var src = el.src || '';
                        var content = el.innerHTML || '';
                        
                        // Verifica cada assinatura
                        for (var signature in signatures) {
                            var presetKey = signatures[signature];
                            
                            // Se encontrar a assinatura no SRC ou no Conteúdo Inline
                            if ( (src && src.indexOf(signature) > -1) || (content && content.indexOf(signature) > -1) ) {
                                if (!detectedPresets.includes(presetKey)) {
                                    detectedPresets.push(presetKey);
                                }
                            }
                        }
                    });

                    // 4. Mostra o Resultado
                    displayResults(detectedPresets);
                })
                .catch(err => {
                    $results.html('<p style="color:red">Error scanning site: ' + err.message + '</p>');
                })
                .finally(() => {
                    $btn.removeClass('disabled');
                    $spinner.removeClass('is-active');
                });
        });

        function displayResults(detectedKeys) {
            var $results = $('#wpcm-scan-results');
            
            if (detectedKeys.length === 0) {
                $results.html('<div class="notice notice-warning inline"><p>No known tracking scripts detected on the homepage.</p></div>');
                return;
            }

            var html = '<div class="notice notice-success inline"><p>We detected <strong>' + detectedKeys.length + '</strong> services!</p></div>';
            html += '<form method="post" action="' + wpcm_scanner_vars.admin_url + 'admin-post.php">';
            html += '<input type="hidden" name="action" value="wpcm_save_wizard">'; // Reutiliza a lógica do Wizard
            html += '<input type="hidden" name="wpcm_wizard_security" value="' + wpcm_scanner_vars.nonce + '">';
            
            html += '<ul class="wpcm-scan-list">';
            detectedKeys.forEach(function(key) {
                // Aqui você precisaria de um mapa JS de chaves -> Títulos legíveis,
                // ou enviar esses títulos via wp_localize_script
                html += '<li><label><input type="checkbox" name="wpcm_services[]" value="' + key + '" checked> ' + key + '</label></li>';
            });
            html += '</ul>';
            
            html += '<button type="submit" class="button button-primary">Add Selected Services</button>';
            html += '</form>';

            $results.html(html);
        }
    });
})(jQuery);